﻿Imports System.Runtime.InteropServices
Imports System.IO

Public Class Program

  ' The name of the dll file to load
  Private Const kDllName As String = "SecureProp.dll"

  ' Match the calling convention of the "GetRevealedTextLength" exported function
  <DllImport(kDllName, CharSet:=CharSet.Unicode)>
  Private Shared Function GetRevealedTextLength(ByVal aSecuredText As String) As UInteger
  End Function

  ' Match the calling convention of the "RevealText" exported function
  <DllImport(kDllName, CharSet:=CharSet.Unicode)>
  Private Shared Sub RevealText(ByVal aSecuredText As String, ByVal aPlainTextBuffer As String, ByVal aBufferLength As UInteger)
  End Sub

  Private Shared Sub LoadPropertiesFromIni(ByRef aProperties As List(Of SecuredProperty))
    Const kIniName As String = "SecureProp.ini"

    If (Not File.Exists(kIniName)) Then
      ' Couldn't load the ini file, so just output an error message
      System.Console.WriteLine("Couldn't load " + kIniName)
      Return
    End If

    Dim lines As String() = File.ReadAllLines(kIniName)
    For Each line As String In lines
      If (line.Contains("=")) Then
        Dim index As Integer = line.IndexOf("=")
        aProperties.Add(New SecuredProperty With
                        {.mName = line.Substring(0, index), .mValue = line.Substring(index + 1)})
      End If
    Next
  End Sub

  Shared Sub Main()
    ' Load the properties from the ini file
    Dim properties As List(Of SecuredProperty) = New List(Of SecuredProperty)
    LoadPropertiesFromIni(properties)

    If (properties.Count.Equals(0)) Then
      Return
    End If

    '------------------------------------------------------------------------------------------
    ' Use the SecureProp library
    '------------------------------------------------------------------------------------------
    For Each securedProp As SecuredProperty In properties
      Dim propValue As String = securedProp.mValue

      '------------------------------------------------------------------------------------------
      ' Exported function call
      ' Reveal the secured text And return its length
      '------------------------------------------------------------------------------------------
      Dim textLength As UInteger = GetRevealedTextLength(propValue)

      ' Allocate a buffer of wide characters with the length textLength + 1
      ' We need to add 1 in order to provide space for the null terminator
      textLength += 1
      Dim textBuffer As Char() = New Char(textLength) {}
      Dim textBufferStr As String = New String(textBuffer)

      '------------------------------------------------------------------------------------------
      ' Exported function call
      ' Reveal the secured text And store the result in the provided buffer
      '------------------------------------------------------------------------------------------
      RevealText(propValue, textBufferStr, textLength)

      ' Output the revealed text
      System.Console.WriteLine(securedProp.mName + " = " + textBufferStr)
    Next

    System.Console.ReadKey()
  End Sub

End Class
